var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { logger } from '../../shared/logger.js';
import { filterOutUntrustedFiles } from './filterOutUntrustedFiles.js';
import { runSecurityCheckIfEnabled } from './runSecurityCheckIfEnabled.js';
// marks which files are suspicious and which are safe
export const validateFileSafety = (rawFiles_1, progressCallback_1, config_1, ...args_1) => __awaiter(void 0, [rawFiles_1, progressCallback_1, config_1, ...args_1], void 0, function* (rawFiles, progressCallback, config, deps = {
    runSecurityCheckIfEnabled,
    filterOutUntrustedFiles,
}) {
    const suspiciousFilesResults = yield deps.runSecurityCheckIfEnabled(rawFiles, config, progressCallback);
    const safeRawFiles = deps.filterOutUntrustedFiles(rawFiles, suspiciousFilesResults);
    const safeFilePaths = safeRawFiles.map((file) => file.path);
    logger.trace('Safe files count:', safeRawFiles.length);
    return {
        safeRawFiles,
        safeFilePaths,
        suspiciousFilesResults,
    };
});
//# sourceMappingURL=validateFileSafety.js.map